%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% Ivan Marinkovic
% R 140/2000
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
%
% SISTEMI LINEARNIH JEDNACINA. NELINEARNE JEDNACINE
%               5. ZADATAK
%
% b) Na slucajan nacin izabrati 100 kvadratnih matrica An, n=1, 2, ..., 100, a zatim im naci
%    inverzne matrice koriscenjem gornjeg programa i MatLAB funkcije inv(A).
%    Graficki prikazati zavisnost norme razlike dobijenih resenja od mere uslovljenosti matrice An.
%    (Program treba da izbaci iz razmatranja matrice An koje su singularne).
%
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

function programb
  fprintf('\n\n')
  R=MyInputN('Unesite format kvadratnih matrica: ');
  V=input('Unesite najveci element matrice: ');
  GRAF_VREDNOSTI=[];    % vrednosti potrebene za grafik
  for i=1:100
    MAT=V*randn(R);     % nasumicno izabrana matrica
    r=regularnost(MAT); % provera regularnosti
    if r==2
      fprintf('Greska: Ne razmatramo singularne matrice!\n')
      MAT
    else
      GAU=gaus_inverz(MAT);              % inverz Gausovom metodom
      INV=inv(MAT);                      % inverz MatLAB funkcija
      GRAF_VREDNOSTI(1,i)=cond(MAT);     % norma matrica
      GRAF_VREDNOSTI(2,i)=norm(INV-GAU); % norma razlike
    end
  end
  GRAF_VREDNOSTI=grafik_m_sort(GRAF_VREDNOSTI);
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% crtanje grafika
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  plot(GRAF_VREDNOSTI(1,:), GRAF_VREDNOSTI(2,:), '-r')
  hold on
    plot(GRAF_VREDNOSTI(1,:),GRAF_VREDNOSTI(2,:),'o','MarkerFaceColor','b','MarkerSize',2)  % dodavanje cvorova na grafik
  hold off
  grid off
  axis on
  axis manual
  axis([min(GRAF_VREDNOSTI(1,:)) max(GRAF_VREDNOSTI(1,:)) min(GRAF_VREDNOSTI(2,:)) max(GRAF_VREDNOSTI(2,:))])
  xlabel('Mera uslovljenosti')
  ylabel('Norma razlike')
  title('Zavisnost norme rzlike od mere uslovljenosti')
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% funkcija obezbedjuje unos prirodnog broja
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
function y=MyInputN(text)
  a=input(text);
  a=fix(a);
  while (a<0)
    a=input(text);
    a=fix(a);
  end
  y=a;